/**
 * The Forgotten Server - a free and open-source MMORPG server emulator
 * Copyright (C) 2019  Mark Samman <mark.samman@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SRC_CREATURES_PLAYERS_MANAGEMENT_WAITLIST_H_
#define SRC_CREATURES_PLAYERS_MANAGEMENT_WAITLIST_H_

struct WaitListInfo;

class WaitingList
{
	public:
		static WaitingList& getInstance();

		bool clientLogin(const Player* player);
		std::size_t getClientSlot(const Player* player);
		static std::size_t getTime(std::size_t slot);

	private:
		WaitingList();

		std::unique_ptr<WaitListInfo> info;
};

#endif  // SRC_CREATURES_PLAYERS_MANAGEMENT_WAITLIST_H_
